/*
 * This file was automatically generated by EvoSuite
 * Sun Mar 03 02:34:25 GMT 2024
 */

package com.ib.client;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.EWrapperMsgGenerator;
import com.ib.client.Execution;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.UnderComp;
import java.util.Vector;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EWrapperMsgGenerator_ESTest extends EWrapperMsgGenerator_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ContractDetails contractDetails0 = new ContractDetails();
      String string0 = EWrapperMsgGenerator.scannerData(0, 10, contractDetails0, (String) null, "", "", "gd!3DzpX7kUJG7]rd");
      assertEquals("id = 0 rank=10 symbol=null secType=null expiry=null strike=0.0 right=null exchange=null currency=null localSymbol=null marketName=null tradingClass=null distance=null benchmark= projection= legsStr=gd!3DzpX7kUJG7]rd", string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.realtimeBar(121, 0L, (-71.03372927354), 0.0, (-1326.5022002670541), (-1326.5022002670541), (-1643L), 0.0, 0);
      assertEquals("id=121 time = 0 open=-71.03372927354 high=0.0 low=-1326.5022002670541 close=-1326.5022002670541 volume=-1643 count=0 WAP=0.0", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.historicalData((-145), "current time = 0 (Jan 1, 1970 12:00:00 AM)", 585, 0.0, (-145), 0.0, (-1482), 0, 0.0, false);
      assertEquals("id=-145 date = current time = 0 (Jan 1, 1970 12:00:00 AM) open=585.0 high=0.0 low=-145.0 close=0.0 volume=-1482 count=0 WAP=0.0 hasGaps=false", string0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateMktDepthL2(10, 10, "id=0  unknown: vol = N/A delta = 1.0", 0, 522, 343.1504063468, (-2792));
      assertEquals("updateMktDepth: 10 10 id=0  unknown: vol = N/A delta = 1.0 0 522 343.1504063468 -2792", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateMktDepth(0, 5919, 2495, 0, (-4772), 5919);
      assertEquals("updateMktDepth: 0 5919 2495 0 -4772.0 5919", string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Contract contract0 = new Contract();
      String string0 = EWrapperMsgGenerator.updatePortfolio(contract0, 0, 530.4014, 1.7976931348623157E308, 0.0, (-1225.33), 0.0, "accountDownloadEnd: id=-1189  unknown=650");
      assertEquals("updatePortfolio: conid = 0\nsymbol = null\nsecType = null\nexpiry = null\nstrike = 0.0\nright = null\nmultiplier = null\nexchange = null\nprimaryExch = null\ncurrency = null\nlocalSymbol = null\n0 530.4014 1.7976931348623157E308 0.0 -1225.33 0.0 accountDownloadEnd: id=-1189  unknown=650", string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.orderStatus(0, "", 0, 0, 1.0, 0, (-893), 1.0, (-451), "id=0 =============== end ===============");
      assertEquals("order status: orderId=0 clientId=-451 permId=0 status= filled=0 remaining=0 avgFillPrice=1.0 lastFillPrice=1.0 parent Id=-893 whyHeld=id=0 =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickEFP((-1), (-1), (-2352.009), ";Kc0N&}jA#@pksV_5^{", (-1), (-1546), "", (-2352.009), (-1010.71090605));
      assertEquals("id=-1  unknown: basisPoints = -2352.009/;Kc0N&}jA#@pksV_5^{ impliedFuture = -1.0 holdDays = -1546 futureExpiry =  dividendImpact = -2352.009 dividends to expiry = -1010.71090605", string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickOptionComputation(0, (-1), (-102.90836663), 1.0, 1.0, 0.0);
      assertEquals("id=0  unknown: vol = N/A delta = 1.0", string0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickOptionComputation(0, 0, 0, 0, 0, (-1690.2596294763582));
      assertEquals("id=0  bidSize: vol = 0.0 delta = 0.0", string0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickPrice((-2099), (-2099), (-2099), (-2099));
      assertEquals("id=-2099  unknown=-2099.0  canAutoExecute", string0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickPrice((-3424), 0, (-62.44820457), 3384);
      assertEquals("id=-3424  bidSize=-62.44820457  canAutoExecute", string0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      ContractDetails contractDetails0 = new ContractDetails();
      Execution execution0 = new Execution(0, 0, "Q~]l-2C+TZJT0@", "FA: null id=2145310180  unknown=2.14531018E9  canAutoExecute", "#54I>t", " ?r.k'ywgbV>e-~", (String) null, (-1073741824), 0.0, (-877), 13, 3, 3614.83);
      String string0 = EWrapperMsgGenerator.execDetails((-2942), contractDetails0.m_summary, execution0);
      assertEquals(" ---- Execution Details begin ----\nreqId = -2942\norderId = 0\nclientId = 0\nsymbol = null\nsecType = null\nexpiry = null\nstrike = 0.0\nright = null\ncontractExchange = null\ncurrency = null\nlocalSymbol = null\nexecId = Q~]l-2C+TZJT0@\ntime = FA: null id=2145310180  unknown=2.14531018E9  canAutoExecute\nacctNumber = #54I>t\nexecutionExchange =  ?r.k'ywgbV>e-~\nside = null\nshares = -1073741824\nprice = 0.0\npermId = -877\nliquidation = 13\ncumQty = 3\navgPrice = 3614.83\n ---- Execution Details end ----\n", string0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      UnderComp underComp0 = new UnderComp();
      String string0 = EWrapperMsgGenerator.deltaNeutralValidation(0, underComp0);
      assertEquals("id = 0 underComp.conId =0 underComp.delta =0.0 underComp.price =0.0", string0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Contract contract0 = new Contract();
      String string0 = EWrapperMsgGenerator.contractMsg(contract0);
      assertEquals("conid = 0\nsymbol = null\nsecType = null\nexpiry = null\nstrike = 0.0\nright = null\nmultiplier = null\nexchange = null\nprimaryExch = null\ncurrency = null\nlocalSymbol = null\n", string0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.updatePortfolio((Contract) null, 0, 0, 99, 99, 99, 0.0, "");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.scannerData(2144259198, 983, (ContractDetails) null, "id=-1362 date = reqId = -1362 =============== end =============== open=-1362.0 high=1500.66866963473 low=0.0 close=1009.8430652252 volume=-1602 count=-1362 WAP=-1362.0 hasGaps=true", ",)", "updateAccountValue: bW`;?_&A1*p1Nu id=-1362 date = reqId = -1362 =============== end =============== open=-1362.0 high=1500.66866963473 low=0.0 close=1009.8430652252 volume=-1602 count=-1362 WAP=-1362.0 hasGaps=true bW`;?_&A1*p1Nu bW`;?_&A1*p1Nu", "q4");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Contract contract0 = new Contract();
      OrderState orderState0 = new OrderState(".9+zC\"1'x32", "\nsymbol = ", (String) null, (String) null, (-2275), 2069, 0.0, (String) null, (String) null);
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.openOrder((-1), contract0, (Order) null, orderState0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.fundamentalData(0, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.contractDetails(2086, (ContractDetails) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.bondContractDetails((-5427), (ContractDetails) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.contractMsg((Contract) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Vector<Integer> vector0 = new Vector<Integer>();
      Contract contract0 = new Contract(13, ": pvDivqkidend = ", "FA: null id=2145310180  unknown=1.0  canAutoExecute", "BOND", (-3737.8081), "id=13  modelOptComp: basisPoints = 13.0/id=2145310180  unknown=1.0  canAutoExecute impliedFuture = -1.0 holdDays = 13 futureExpiry = : pvDivqkidend =  dividendImpact = 1.0 dividends to expiry = 92.7", "BOND", "m?| Cl{d%[lF8*9J", "w7Ys.xZ,Uq}", "m?| Cl{d%[lF8*9J", vector0, "Cu+xYDpAi", false, "Connection Closed", "BOND");
      Order order0 = new Order();
      OrderState orderState0 = new OrderState();
      String string0 = EWrapperMsgGenerator.openOrder(1400, contract0, order0, orderState0);
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickOptionComputation((-685), Integer.MAX_VALUE, 1.7976931348623157E308, 0.0, 1.7976931348623157E308, 0);
      assertEquals("id=-685  unknown: vol = N/A delta = 0.0", string0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickOptionComputation((-574), 402, 4507.9936551, 0.0, 4137.56879114, 0);
      assertEquals("id=-574  unknown: vol = 4507.9936551 delta = 0.0", string0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickOptionComputation(959, (-104), (-1.0), (-3737.8081), Integer.MAX_VALUE, 1114.0);
      assertEquals("id=959  unknown: vol = N/A delta = N/A", string0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickPrice(0, 0, 1449.38658342313, 0);
      assertEquals("id=0  bidSize=1449.38658342313  noAutoExecute", string0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateMktDepth(964, 964, (-727), (-76), (-727), (-2967));
      assertEquals("updateMktDepth: 964 964 -727 -76 -727.0 -2967", string0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickString(0, 1288, "");
      assertEquals("id=0  unknown=", string0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.deltaNeutralValidation(0, (UnderComp) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateNewsBulletin((-1496), 0, "\"$mXBj;n\"#XC/", (String) null);
      assertEquals("MsgId=-1496 :: MsgType=0 :: Origin=null :: Message=\"$mXBj;n\"#XC/", string0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.fundamentalData(0, "h%(4&9G\"Gv|cT");
      assertEquals("id  = 0 len = 13\nh%(4&9G\"Gv|cT", string0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      ContractDetails contractDetails0 = new ContractDetails();
      String string0 = EWrapperMsgGenerator.updatePortfolio(contractDetails0.m_summary, 0, 0.0, (-368.9606896891253), 1844, 1.7976931348623157E308, 0.0, "0}n&q6M&?X9isy#u");
      assertEquals("updatePortfolio: conid = 0\nsymbol = null\nsecType = null\nexpiry = null\nstrike = 0.0\nright = null\nmultiplier = null\nexchange = null\nprimaryExch = null\ncurrency = null\nlocalSymbol = null\n0 0.0 -368.9606896891253 1844.0 1.7976931348623157E308 0.0 0}n&q6M&?X9isy#u", string0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateAccountValue((String) null, "", "com.ib.client.AnyWrapperMsgGenerator", "");
      assertEquals("updateAccountValue: null  com.ib.client.AnyWrapperMsgGenerator ", string0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.receiveFA((-1496), (String) null);
      assertEquals("FA: null null", string0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.contractDetailsEnd(13);
      assertEquals("reqId = 13 =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickSnapshotEnd(2072);
      assertEquals("id=2072 =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.orderStatus(1, (String) null, 0, (-1113), 3068, (-3258), 3068, 146L, 3068, (String) null);
      assertEquals("order status: orderId=1 clientId=3068 permId=-3258 status=null filled=0 remaining=-1113 avgFillPrice=3068.0 lastFillPrice=146.0 parent Id=3068 whyHeld=null", string0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.scannerDataEnd(2865);
      assertEquals("id = 2865 =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickGeneric(597, 1069, (-1189));
      assertEquals("id=597  unknown=-1189.0", string0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.managedAccounts("bW`;?_&A1*p1Nu");
      assertEquals("Connected : The list of managed accounts are : [bW`;?_&A1*p1Nu]", string0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      EWrapperMsgGenerator eWrapperMsgGenerator0 = new EWrapperMsgGenerator();
      assertEquals("Connection Closed", eWrapperMsgGenerator0.connectionClosed());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      ContractDetails contractDetails0 = new ContractDetails();
      String string0 = EWrapperMsgGenerator.contractDetails(2039, contractDetails0);
      assertEquals("reqId = 2039 ===================================\n ---- Contract Details begin ----\nconid = 0\nsymbol = null\nsecType = null\nexpiry = null\nstrike = 0.0\nright = null\nmultiplier = null\nexchange = null\nprimaryExch = null\ncurrency = null\nlocalSymbol = null\nmarketName = null\ntradingClass = null\nminTick = 0.0\nprice magnifier = 0\norderTypes = null\nvalidExchanges = null\nunderConId = 0\nlongName = null\ncontractMonth = null\nindustry = null\ncategory = null\nsubcategory = null\ntimeZoneId = null\ntradingHours = null\nliquidHours = null\n ---- Contract Details End ----\n", string0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.accountDownloadEnd((String) null);
      assertEquals("accountDownloadEnd: null", string0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateMktDepthL2(279, 342, "", 342, 0, (-3021.0), 122);
      assertEquals("updateMktDepth: 279 342  342 0 -3021.0 122", string0);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Contract contract0 = new Contract();
      ContractDetails contractDetails0 = new ContractDetails(contract0, (String) null, (String) null, 0.0, "Error - ", " open=", 279, "vCSC$xa;[", "", "", "", "id=13  bidSize=758.640479404691  canAutoExecute", (String) null, "updateMktDepth: 279 342  342 0 -3021.0 122", "updateAccountTime: ");
      String string0 = EWrapperMsgGenerator.bondContractDetails(0, contractDetails0);
      assertEquals("reqId = 0 ===================================\n ---- Bond Contract Details begin ----\nsymbol = null\nsecType = null\ncusip = null\ncoupon = 0.0\nmaturity = null\nissueDate = null\nratings = null\nbondType = null\ncouponType = null\nconvertible = false\ncallable = false\nputable = false\ndescAppend = null\nexchange = null\ncurrency = null\nmarketName = null\ntradingClass = null\nconid = 0\nminTick = 0.0\norderTypes = Error - \nvalidExchanges =  open=\nnextOptionDate = null\nnextOptionType = null\nnextOptionPartial = false\nnotes = null\nlongName = vCSC$xa;[\n ---- Bond Contract Details End ----\n", string0);
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.realtimeBar(0, 1420L, 0.0, 0, 1420L, 0.0, 146L, 146L, (-1765));
      assertEquals("id=0 time = 1420 open=0.0 high=0.0 low=1420.0 close=0.0 volume=146 count=-1765 WAP=146.0", string0);
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.nextValidId(10);
      assertEquals("Next Valid Order ID: 10", string0);
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.execDetailsEnd(0);
      assertEquals("reqId = 0 =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.currentTime(1);
      assertEquals("current time = 1 (Jan 1, 1970 12:00:01 AM)", string0);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.openOrderEnd();
      assertEquals(" =============== end ===============", string0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickEFP((-4772), 0, (-3622.92), (String) null, (-4772), 0, (String) null, (-1034.354), (-3622.92));
      assertEquals("id=-4772  bidSize: basisPoints = -3622.92/null impliedFuture = -4772.0 holdDays = 0 futureExpiry = null dividendImpact = -1034.354 dividends to expiry = -3622.92", string0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Execution execution0 = new Execution();
      // Undeclared exception!
      try { 
        EWrapperMsgGenerator.execDetails((-963), (Contract) null, execution0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("com.ib.client.EWrapperMsgGenerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.tickSize(3068, 0, 1637);
      assertEquals("id=3068  bidSize=1637", string0);
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.scannerParameters("%}&l`I");
      assertEquals("SCANNER PARAMETERS:\n%}&l`I", string0);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.historicalData((-1362), "reqId = -1362 =============== end ===============", (-1362), 1500.66866963473, 0.0, 1009.8430652252, (-1602), (-1362), (-1362), true);
      assertEquals("id=-1362 date = reqId = -1362 =============== end =============== open=-1362.0 high=1500.66866963473 low=0.0 close=1009.8430652252 volume=-1602 count=-1362 WAP=-1362.0 hasGaps=true", string0);
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      String string0 = EWrapperMsgGenerator.updateAccountTime(" algoStrategy=");
      assertEquals("updateAccountTime:  algoStrategy=", string0);
  }
}
